package h.com.serialapp.activity

import android.content.Intent
import android.os.Bundle
import android.serialport.SerialPortFinder
import android.view.View
import android.widget.AdapterView
import android.widget.ArrayAdapter
import h.com.serialapp.R
import h.com.serialapp.R.array.baudrates
import h.com.serialapp.util.PrefHelper
import h.com.serialapp.util.ToastUtil
import h.com.serialapp.util.constant.PreferenceKeys
import h.com.serialportapi.comn.Device
import h.com.serialportapi.comn.SerialPortManager
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : BaseActivity(), AdapterView.OnItemSelectedListener {

    private lateinit var mDevices: Array<String>
    private var mDeviceIndex: Int = 0
    private var mBaudrateIndex: Int = 0
    private var mDevice: Device? = null
    private lateinit var mBaudrates: Array<String>
    var isOpen = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        init()
        initSpinner()
        btn_open_device.setOnClickListener(View.OnClickListener {
            isOpen = SerialPortManager.instance().open(mDevice) != null
            if (isOpen) {
                startActivity(Intent(this, HomeActivity().javaClass))
                finish()
            } else {
                ToastUtil.showOne(this, "请检查设备")
            }
        })
    }

    fun init() {
        val serialPortFinder = SerialPortFinder()

        // 设备
        mDevices = serialPortFinder.allDevicesPath
        if (mDevices.size == 0) {
            mDevices = arrayOf(getString(R.string.no_serial_device))
        }
        // 波特率
        mBaudrates = resources.getStringArray(baudrates)

        mDeviceIndex = PrefHelper.getDefault().getInt(PreferenceKeys.SERIAL_PORT_DEVICES, 0)
        mDeviceIndex = if (mDeviceIndex >= mDevices.size) mDevices.size - 1 else mDeviceIndex
        mBaudrateIndex = PrefHelper.getDefault().getInt(PreferenceKeys.BAUD_RATE, 0)

        mDevice = Device(mDevices[mDeviceIndex], mBaudrates[mBaudrateIndex])
    }

    fun initSpinner() {
        val deviceAdapter = ArrayAdapter<String>(this, R.layout.spinner_default_item, mDevices)
        deviceAdapter.setDropDownViewResource(R.layout.spinner_item)
        spinner_devices.setAdapter(deviceAdapter)
        spinner_devices.setOnItemSelectedListener(this)

        val baudrateAdapter = ArrayAdapter<String>(this, R.layout.spinner_default_item, mBaudrates)
        baudrateAdapter.setDropDownViewResource(R.layout.spinner_item)
        spinner_baudrate.setAdapter(baudrateAdapter)
        spinner_baudrate.setOnItemSelectedListener(this)

        spinner_devices.setSelection(mDeviceIndex)
        spinner_baudrate.setSelection(mBaudrateIndex)
    }

    override fun onItemSelected(parent: AdapterView<*>?, view: View?, position: Int, id: Long) {
        // Spinner 选择监听
        when (parent!!.getId()) {
            R.id.spinner_devices -> {
                mDeviceIndex = position
                mDevice!!.setPath(mDevices[mDeviceIndex])
            }
            R.id.spinner_baudrate -> {
                mBaudrateIndex = position
                mDevice!!.setBaudrate(mBaudrates[mBaudrateIndex])
            }
        }
    }

    override fun onNothingSelected(parent: AdapterView<*>?) {

    }
}
